
'use client';

import { Header } from '@/components/header';
import { Footer } from '@/components/footer';
import { AnimatedWrapper } from '@/components/animated-wrapper';
import { ServicesOverview } from '@/components/services-overview';
import CoreSectors from '@/components/core-sectors';
import NoorServicesSection from '@/components/noor-services-section';

export default function ServicesPage() {
  return (
      <div className="flex min-h-screen flex-col bg-background pt-20">
            <Header />
                  <main className="flex-1">
                          <div className="space-y-24 sm:space-y-32">
                                    <AnimatedWrapper>
                                                <ServicesOverview />
                                    </AnimatedWrapper>
                                    <AnimatedWrapper>
                                                <NoorServicesSection />
                                    </AnimatedWrapper>
                                    <AnimatedWrapper>
                                                <CoreSectors />
                                    </AnimatedWrapper>
                          </div>
                  </main>
                  <Footer />
      </div>
  );
}
